/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexExecNode;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.result.NoMatchResult;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.result.RegexResult;
import com.oracle.truffle.regex.tregex.nodes.input.InputEndsWithNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputEqualsNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputStartsWithNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.PreCalcResultVisitor;
import com.oracle.truffle.regex.tregex.string.AbstractString;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public abstract class LiteralRegexExecNode
extends RegexExecNode
implements JsonConvertible {
    protected final PreCalculatedResultFactory resultFactory;

    public LiteralRegexExecNode(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
        super(language, ast.getSource(), ast.getFlags().isUnicode());
        this.resultFactory = preCalcResultVisitor.getResultFactory();
    }

    protected String getLiteral() {
        return "";
    }

    @Override
    protected final String getEngineLabel() {
        return "literal:" + this.getImplName() + "(" + this.getLiteral() + ")";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("method", this.getImplName()), Json.prop("literal", DebugUtil.escapeString(this.getLiteral())), Json.prop("factory", this.resultFactory));
    }

    protected abstract String getImplName();

    public static final class RegionMatches
    extends NonEmptyLiteralRegexExecNode {
        @Node.Child
        InputRegionMatchesNode regionMatchesNode = InputRegionMatchesNode.create();

        public RegionMatches(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "regionMatches";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            if (this.regionMatchesNode.execute(input, fromIndex, this.literalContent(), 0, this.literal.encodedLength(), this.maskContent())) {
                return this.resultFactory.createFromStart(fromIndex);
            }
            return NoMatchResult.getInstance();
        }
    }

    public static final class Equals
    extends NonEmptyLiteralRegexExecNode {
        @Node.Child
        InputEqualsNode equalsNode = InputEqualsNode.create();

        public Equals(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "equals";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            if (fromIndex == 0 && this.equalsNode.execute(input, this.literalContent(), this.maskContent())) {
                return this.resultFactory.createFromStart(0);
            }
            return NoMatchResult.getInstance();
        }
    }

    public static final class EndsWith
    extends NonEmptyLiteralRegexExecNode {
        private final boolean sticky;
        @Node.Child
        InputEndsWithNode endsWithNode = InputEndsWithNode.create();

        public EndsWith(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
            this.sticky = ast.getFlags().isSticky();
        }

        @Override
        protected String getImplName() {
            return "endsWith";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            int matchStart = this.inputLength(input) - this.literal.encodedLength();
            if ((this.sticky ? fromIndex == matchStart : fromIndex <= matchStart) && this.endsWithNode.execute(input, this.literalContent(), this.maskContent())) {
                return this.resultFactory.createFromEnd(this.inputLength(input));
            }
            return NoMatchResult.getInstance();
        }
    }

    public static final class StartsWith
    extends NonEmptyLiteralRegexExecNode {
        @Node.Child
        InputStartsWithNode startsWithNode = InputStartsWithNode.create();

        public StartsWith(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "startsWith";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            if (fromIndex == 0 && this.startsWithNode.execute(input, this.literalContent(), this.maskContent())) {
                return this.resultFactory.createFromStart(0);
            }
            return NoMatchResult.getInstance();
        }
    }

    public static final class IndexOfString
    extends NonEmptyLiteralRegexExecNode {
        @Node.Child
        InputIndexOfStringNode indexOfStringNode = InputIndexOfStringNode.create();

        public IndexOfString(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "indexOfString";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            int start = this.indexOfStringNode.execute(input, fromIndex, this.inputLength(input), this.literalContent(), this.maskContent());
            if (start == -1) {
                return NoMatchResult.getInstance();
            }
            return this.resultFactory.createFromStart(start);
        }
    }

    static abstract class NonEmptyLiteralRegexExecNode
    extends LiteralRegexExecNode {
        protected final AbstractString literal;
        protected final AbstractString mask;

        NonEmptyLiteralRegexExecNode(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
            this.literal = preCalcResultVisitor.getLiteral();
            this.mask = preCalcResultVisitor.getMask();
        }

        @Override
        protected String getLiteral() {
            return this.literal.toString();
        }

        Object literalContent() {
            return this.literal.content();
        }

        Object maskContent() {
            return this.mask == null ? null : this.mask.content();
        }
    }

    public static final class EmptyEquals
    extends LiteralRegexExecNode {
        public EmptyEquals(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "emptyEquals";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            assert (fromIndex <= this.inputLength(input));
            return this.inputLength(input) == 0 ? this.resultFactory.createFromStart(0) : NoMatchResult.getInstance();
        }
    }

    public static final class EmptyEndsWith
    extends LiteralRegexExecNode {
        public EmptyEndsWith(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "emptyEndsWith";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            assert (fromIndex <= this.inputLength(input));
            return this.resultFactory.createFromEnd(this.inputLength(input));
        }
    }

    public static final class EmptyStartsWith
    extends LiteralRegexExecNode {
        public EmptyStartsWith(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "emptyStartsWith";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            return fromIndex == 0 ? this.resultFactory.createFromStart(0) : NoMatchResult.getInstance();
        }
    }

    public static final class EmptyIndexOf
    extends LiteralRegexExecNode {
        public EmptyIndexOf(RegexLanguage language, RegexAST ast, PreCalcResultVisitor preCalcResultVisitor) {
            super(language, ast, preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "emptyIndexOf";
        }

        @Override
        protected RegexResult execute(Object input, int fromIndex) {
            return this.resultFactory.createFromStart(fromIndex);
        }
    }
}

